//
//  CRPhotoViewControllerBase.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 04/04/10.
//  Copyright 2011 Neatberry. All rights reserved.
//

@class CRScene;
@class CRSceneItemVisual;
@class CRInplaceEditorController;

extern const NSInteger CRLayerMaskingEditorIndex;

//////////////////////////////////////////////////////////////////////
// Base photo view controller
//////////////////////////////////////////////////////////////////////
@interface CRPhotoViewControllerBase : NSViewController
{
@private
	BOOL							isConnected;
	
@protected
	CRSceneItemVisual* assigned		rootObject;				// scene item to visualize
	CRScene*						source;					// represented scene
	NSInteger						selectedEditorIndex;	// selected editor
	CRInplaceEditorController*		editorController;		// editor controller
	
	// Images
	BOOL							sourceImageIsDirty;		// flag for lazy evaluation
	CIImage*						imageToRender;			// rendering image, depends on selected scene item and active editor rendering mode
	
	// Zoom
	BOOL							autozoom;				// autozoom flag
	
	// Binding manager
	CRTwoWayBindingManager*			bindingManager;			// two-way binding manager, auto
}

@property (nonatomic, assign)	CRSceneItemVisual*				rootObject;				// root scene item
@property (nonatomic, strong)	CRScene*						source;					// represented scene
@property (nonatomic, readonly)	CRInplaceEditorController*		editorController;		// seected inplace controller editor
@property (nonatomic, assign)	NSInteger						selectedEditorIndex;	// active inplace editor index
@property (nonatomic, assign)	CIImage*						imageToRender;			// rendering image
@property (nonatomic, readonly) NSString*						colorSpaceName;			// rendering colorSpace name (CRScene)

@property (nonatomic, readonly)	CGFloat							minimumZoom;			// minimum zoom modifier
@property (nonatomic, readonly)	CGFloat							maximumZoom;			// maximum zoom modifier
@property (nonatomic, readonly)	BOOL							canZoomIn;				// flag signal whether zoom in with default step is possible
@property (nonatomic, readonly)	BOOL							canZoomOut;				// flag signal whether zoom out with default step is possible
@property (nonatomic, assign)	BOOL							autozoom;				// flag signal whether automatic " zoom to fit" is turned on
@property (nonatomic, assign)	CGFloat							zoom;					// current zoom modifier


//////////////////////////////////////////////////////////////////////
#pragma mark General methods

- (BOOL)connect;
- (BOOL)disconnect;

- (void)updateEditor;
- (void)updateRenderingImage;
- (void)zoomViewToFitArea;

- (void)setSelectedEditorIndex:(NSInteger)anIndex force:(BOOL)force;
- (BOOL)updatingWithNewFrame:(NSRect)newFrame oldFrame:(NSRect)oldFrame;

//////////////////////////////////////////////////////////////////////
#pragma mark Subclasses to override

- (void)dropEditor;
- (void)applyEditorWithIndex:(NSUInteger)index root:(id)root;
- (NSRect)fullArea;
- (void)viewInstalled;

//////////////////////////////////////////////////////////////////////
#pragma mark Actions

- (IBAction)zoomIn:(id)sender;
- (IBAction)zoomOut:(id)sender;
- (IBAction)zoomToActualSize:(id)sender;
- (IBAction)toggleAutozoom:(id)sender;

@end